//

function buildUI( tool ) {
  
  tool.addParameterSeparator("Texture Helper");
  
  tool.addParameterString("tex. folder", "Textures", true);
  tool.addParameterButton("gather all textures", "copy", "gatherAllTexture");
  
}

var texpath_list = [];

function gatherAllTexture( tool ) {
  
  var i, j;
  var doc = tool.document();
  
  var subfolder_name = tool.getParameter("tex. folder");
  
  texpath_list.length = 0;
  
  for (i = 0;i < doc.materialCount();i++) {
    var mat = doc.materialAtIndex( i );
    
    /*
    var rootnode = mat.rootNode();
    
    for (j = 0;j < rootnode.inputCount();j++) {
      var para = rootnode.inputAtIndex( j );
      
      if (para.connected() == true) {
        var nodeId = para.connectedWithID();
        var node = mat.nodeWithID( nodeId );
        
        if (node != null && node.nodeType() == "image") {
          var texpath = node.getParameter("texture");
          
          texpath_list.push( texpath );
        }
      }
    }
     */
    
    var nodeCount = mat.nodeCount();   
    for (j = 0;j < nodeCount;j++) {
      var node = mat.nodeAtIndex( j );
      
      if (node != null && node.nodeType() == "image") {
        var texpath = node.getParameter("texture");
        
        texpath_list.push( texpath );
      }
    }
  }
  
  print( texpath_list );
  
  var dir = OS.runOpenPanel("");
  
  if (dir != null) {
    
    if (subfolder_name != "") {
      dir = dir + "/" + subfolder_name.replace(/\//g, "").replace(/\s/g, "_");
      
      OS.system( "mkdir " + dir );
    }
    
    for (i = 0;i < texpath_list.length;i++) {
      var texfile = new File( texpath_list[i] );
      
      texfile.copyTo( dir + "/" + texfile.lastPathComponent() );
    }
  }
  
}